/*trimite T si H de la DHT 11 
 * legat la pin 16
 * * IP192.168.0.80
 * se conecteaza la server local
 * Oled
 * afiseaza continuu pe oled T, H, 
 * lik folosit
 * https://lastminuteengineers.com/esp32-dht11-dht22-web-server-tutorial/
 */

#include <WiFi.h>
#include <WebServer.h>
#include "DHT.h"

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

#define DHTTYPE DHT11   // DHT 11

/*Put your SSID & Password*/
const char* ssid     = "nume router";
const char* password = "password";

WebServer server(80);

uint8_t DHTPin = 16; 
DHT dht(DHTPin, DHTTYPE);                

float Temperature;
float Humidity;
 
void setup() {
  Serial.begin(115200);
  delay(100);
  
  pinMode(DHTPin, INPUT);

  dht.begin();              

  Serial.println("Connecting to ");
  Serial.println(ssid);

  //connect to your local wi-fi network
  WiFi.begin(ssid, password);

  //check wi-fi is connected to wi-fi network
  while (WiFi.status() != WL_CONNECTED) {
  delay(1000);
  Serial.print(".");
  }
  Serial.println("");
  Serial.println("WiFi connected..!");
  Serial.print("Got IP: ");  Serial.println(WiFi.localIP());

  server.on("/", handle_OnConnect);
  server.onNotFound(handle_NotFound);

  server.begin();
  Serial.println("HTTP server started");

  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("oled LocalW DHT11 ESP32 IP=");
  display.print(WiFi.localIP());
  display.display();
  delay(2000);
    }
  void loop() {
  
  server.handleClient();
  float temp = dht.readTemperature();
  float humi = dht.readHumidity();
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("T=");
  display.println(temp);
  
  display.print("H=");
  display.println(humi);
  
  display.display();
    }

  void handle_OnConnect() {

  Temperature = dht.readTemperature(); // Gets the values of the temperature
  Humidity = dht.readHumidity(); // Gets the values of the humidity 
  server.send(200, "text/html", SendHTML(Temperature,Humidity)); 
  }

  void handle_NotFound(){
  server.send(404, "text/plain", "Not found");
  }

  String SendHTML(float Temperaturestat,float Humiditystat){
  String pag = "<!DOCTYPE html> <html>\n";
  pag +="<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=no\">\n";
  pag +="<title>ESP32 Temp Umidit</title>\n";
  pag +="<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}\n";
  pag +="body{margin-top: 50px;} h1 {color: #444444;margin: 50px auto 30px;}\n";
  pag +="p {font-size: 24px;color: #444444;margin-bottom: 10px;}\n";
  pag +="</style>\n";
  
////////////////////// referesh automat
pag +="<script>\n";
pag +="setInterval(loadDoc,200);\n";
pag +="function loadDoc() {\n";
pag +="var xhttp = new XMLHttpRequest();\n";
pag +="xhttp.onreadystatechange = function() {\n";
pag +="if (this.readyState == 4 && this.status == 200) {\n";
pag +="document.getElementById(\"webpage\").innerHTML =this.responseText}\n";
pag +="};\n";
pag +="xhttp.open(\"GET\", \"/\", true);\n";
pag +="xhttp.send();\n";
pag +="}\n";
pag +="</script>\n";
  ////////////////refresh automat
  
  pag +="</head>\n";
  pag +="<body>\n";
  
  pag +="<div id=\"webpage\">\n";
  pag +="<h1>ESP32 Sensors Read</h1>\n";
  
  pag +="<p>Temperature: ";
  pag +=(int)Temperaturestat;
  pag +="°C</p>";
  pag +="<p>Humidity: ";
  pag +=(int)Humiditystat;
  pag +="%</p>";
  
  pag +="</div>\n";
  pag +="</body>\n";
  pag +="</html>\n";
  return pag;
}
